// Bibliothek für die serielle Kommunikation einbinden.
import processing.serial.*;  
// Serielle Schnittstelle (USB-Verbindung zum Arduino)
Serial myPort;         
float abstand;

void setup()
{
  size(400, 400);
  background(255, 255, 0);
  // Alle verfügbaren Schnittstellen auflisten.
  println(Serial.list());

  // Hier die richtige COM Port Nummer angeben
  // Dafür in der Liste in der Console nachschauen.
  myPort = new Serial(this, Serial.list()[0], 9600);
}

void draw()
{
  ellipse(200, 200, 100, 100);
  if (mousePressed) {
    abstand = dist(mouseX, mouseY, 200, 200);
    if (abstand <50) {
      fill(255, 0, 0);
      myPort.write("LED AN");
      // Das ASCII-Zeichen '\n' (= Neue Zeile (NL)) ist nicht 
      // unbedingt nötig. Es soll dem Arduino mitteilen, dass die 
      // Nachricht hier endet, was die Kommunikation stabiler macht.
      myPort.write('\n');
    }
    else {
      fill(0, 255, 0);
      myPort.write("LED AUS");
      myPort.write('\n');
    }
  }
}

