/*
 Dieser Quellcode ist dem Buch "Rapid Android Development" von D. Sauter entnommen.
 Siehe http://danielsauter.com
 */

// Verweis auf die ketai-Bibliothek mittels der auf die Sensorwerte zugegriffen wird.
import ketai.sensors.*;

// Analog wie bei der BT-Bibliothek ketai.net.bluetooth.* bedarf es eine Variable für das Sensorobjekt.
KetaiSensor sensor;
// In diesen Variablen werden später die x-,y- unc z-Beschleunigungswerte eingetragen.
float beschleunigungX, beschleunigungY, beschleunigungZ;

void setup()
{
  size(400, 400);
  // Analog wie bei der BT-Bibliothek ketai.net.bluetooth.* muss ein Sensorobjekt erzeugt werden.
  sensor = new KetaiSensor(this);
  // Hiermit wird ein Dienst gestartet, der sich über die Callbackmethode zurück meldet,
  // falls sich ein Sensorwert geändert hat.
  sensor.start();
  // Bildschirm des Androidgeräts bleibt quer ausgerichtet, egal wie es gedreht wird.
  orientation(LANDSCAPE);
  // Der Text auf dem Bildschirm soll in der Mitte dargestellt werden in der Schriftgröße 36.
  textAlign(CENTER, CENTER); 
  textSize(36);
}

void draw()
{
  //Gelber Hintergrundbildschirm
  background(255, 255, 0);
  //Ausgeben der Beschleunigungswerte auf dem Bildschirm in Schwarz.
  fill(0, 0, 0);
  text("B-Sensorwerte (m/s²):\n" + //(3)
  "ax: " + nfp(beschleunigungX, 2, 3) + "\n" +
    "ay: " + nfp(beschleunigungY, 2, 3) + "\n" +
    "az: " + nfp(beschleunigungZ, 2, 3), width/2, height/2);
}

//Diese Methode wird jedes Mal automatisch aufgerufen, wenn sich ein
//Sensorwert geändert hat.
void onAccelerometerEvent(float x, float y, float z)
{
  beschleunigungX = -x;
  beschleunigungY = -y;
  beschleunigungZ = -z;
}

