#include <Servo.h>

Servo mServo;
int werte[3]; //Array für die beiden Integerwerte
int arrayIndex = 0; //Arrayindex initialisieren.
int kommaZahl = 0; //Anzal der empfangenen Werte
int sensorWert = 0; //Digitalwert des Helligkeitssensors

void setup() {
  Serial.begin(9600);
  mServo.attach(3);
  Serial.println("Drei Integerwerte getrennt mit Komma eingeben:");
  delay(1000);
}

void loop() {
  sensorWert = analogRead(A0);
  if( Serial.available())
  {
    char ch = Serial.read();
    // Falls die ASCII Zeichen Ziffern sind.
    if(ch >= '0' && ch <= '9')
    {
      //ASCII Wert in Ziffer konvertieren und aus Ziffern Dezimalzahl machen.
      werte[arrayIndex] = (werte[arrayIndex] * 10) + (ch - '0'); 
    }
    else if (ch == ',') // Wenn Komma, dann zum nächsten Arrayelement wechseln.
    {
      arrayIndex = min(arrayIndex++,2); // Den Index auf maximal 2 begrenzen
      kommaZahl++;
    }
    else if (ch =='\n') // Wenn letztes Zeichen Protokoll empfangen und zwei Werte da.
    {
      mServo.write(werte[0]);
      Serial.print(kommaZahl);
      Serial.print(",");
      Serial.println(sensorWert);
      for(int i=0; i <= 2; i++) werte[i] = 0; // Wertearray zurücksetzen.
      arrayIndex = 0;
      kommaZahl = 0;
    }
    else
    {
      kommaZahl = 99;
    }  
  }
}






