// ArduSmartPilot Programm ("Firmware") für den ESP8266 (ESP-201)
//*******
// Herzlichen Dank an Hr. G. Brandhorst für dieses geniale Beispielprogramm!
//*******
//Anders als bei der Bluetooth(BT)-Version des ArduSmartPilot-Programms wird hier
//nicht ein Arduino Pro Mini sondern ein ESP8266 µC Board verwendet. Dieses µC Board
//verfügt über eine WLAN-Schnittstelle, die als Access Point fungiert. In dieses WLAN
//bucht sich das Smartphone mit er (ebenfalls modifizierten) App "ArduSmartPilot_WiFi" ein
//und steuert dann den ArduSmartPilot fast genau so wie mittels BT.
//Dieses Programm hier kann ebenfalls mit der Arduino IDE kompiliert und an den µC übertragen
//werden, wenn man hier unter Datei -> Voreinstellungen -> Additional Boards Manager URLs:
//"http://arduino.esp8266.com/staging/package_esp8266com_index.json" eingibt.
//Danach eingeben:
//Werkzeuge -> Platine -> Boards Manager -> esp8266 installieren
//Und dann einstellen:
//Platine: "Generic ESP8266 module"
//Flash Mode: "DIO"
//Flash Frequency: "40MHz"
//Upload Using: "Serial"
//CPU Frequency: "80MHz"
//Flash Size: "512K (64K SPIFFS)"
//Upload Speed "115200"
//Port: "COM40" (kann variieren)
//Programmer: "Arduino as ISP"
//
//Beim ESP-201 müssen für das Hochladen folgende Pins wie folgt belegt werden:
//CHP-EN: 3,3 V; IO0: GND; IO2: 3,3 V; IO15: GND; Vor dem Hochladen Reset drücken (RST kurz auf GND)
//Danach muss IO0 von GND entfernt werden (floatet dann) und Reset drücken, damit das Programm startet.
//(Offiziell müsste IO0 auf 3,3 V sein, dann startet aber WLAN nicht...)
//Da hier die serielle Schnittstelle für die Kommunikation zum Smartphone nicht
//verwendet wird, wird darüber der Programmablauf im Serial Monitor gelogged
//falls der ESP via USB/Seriell Wandler verbunden ist.
//In dieser Version jetzt Rückkommunikation an das Smartphone über die Verwendung
//der esp8266-OSC Bibliothek /github.com/sandeepmistry/esp8266-OSC
//Die Frage ist, ob das Empfangen der Steuerdaten auch über OSC und nicht wie jetzt über die UDP Bibliothek
//gemaacht wird.
//Degugschalter eingefügt - macht den Programmablauf aber nicht schneller.
//...
//S. Mack, 7.12.15

#include <ESP8266WiFi.h>
#include <WiFiUDP.h>
//Damit OSC Protokoll verwendet werden kann
#include<OSCMessage.h>
#include <Servo.h>
// Debug Schalter (true = mit serieller Kommunikation). Dann leuchtet blaue LED nicht
// mehr, Zykluszeit wird nicht merklich schneller. Daher besser auf true lassen, dann
// dann sieht man, wenn Kommunikation läuft (blaue LED blinkt schnell, da mit TX verbunden).
// Wenn Not Aus, dann leuchtet blaue LED (fast) kontinuierlich.
const boolean (DEBUG) = true;
Servo seitenRuder, hoehenRuder, motorRegler;

int posSeiten = 0;
int posHoehen = 0;
int leistMotor = 0;
unsigned long lastsignal = 0;
int werte[3];
int arrayIndex = 0;
//Zeit in ms für 10 empfangene Steuersignale (zum Erkennen Qualität WLAN-Verbindung). Da das Processingprogramm
//derzeit mit frameRate=20 sendet, ist dieser Wert normal ca. 800 ms.
unsigned long zeitSteuerAlt = 0;
unsigned long zeitSteuerNeu = 0;
int zaehlSensor = 0;

const char* ssidap = "ArduSmartPilot";
//Port zum Empfangen der Daten vom Smartphone
unsigned int localPort = 12000;
char packetBuffer[255];

WiFiUDP Udp;
//IP-Adresse des ESP-201
IPAddress targetip(192, 168, 1, 3);
IPAddress subnet(255, 255, 255, 0);
IPAddress myIP;

void setup()
{
  if (DEBUG) Serial.begin(115200);
  if (DEBUG) delay(8000);

  WiFi.mode(WIFI_AP);
  WiFi.softAP(ssidap);
  WiFi.softAPConfig(targetip, targetip, subnet);
  myIP = WiFi.softAPIP();
  if (DEBUG) Serial.print("Access Point IP: ");
  if (DEBUG) Serial.println(myIP);

  delay(2000);
  if (DEBUG) Serial.print("Listening on port: ");
  if (DEBUG) Serial.println(localPort);
  Udp.begin(localPort);

  delay(4000);
  if (DEBUG) Serial.print("Remote IP: ");
  if (DEBUG) Serial.println(Udp.remoteIP());

  seitenRuder.attach(12);
  hoehenRuder.attach(13);
  motorRegler.attach(14);
  seitenRuder.write(85);
  hoehenRuder.write(70);
  motorRegler.write(20);
  delay(300);
}

void loop() {
  int packetSize = Udp.parsePacket();
  if (packetSize > 0) {
    int len = Udp.read(packetBuffer, 255);
    if (len > 0) packetBuffer[len] = 0;
    if (DEBUG) Serial.print("Received: ");
    if (DEBUG) Serial.print(packetBuffer);

    for (int packetcounter = 0; packetcounter < len; packetcounter++) {
      char ch = packetBuffer[packetcounter];
      if (ch >= '0' && ch <= '9')
      {
        werte[arrayIndex] = (werte[arrayIndex] * 10) + (ch - '0');
      }
      else if (ch == ',')
      {
        arrayIndex++;
        if (arrayIndex > 2) arrayIndex = 2;
      }
      else if (ch == '\n')
      {
        posSeiten = (int)map(werte[0], 0, 180, 0, 180);
        posHoehen = (int)map(werte[1], 0, 180, 180, 0);
        leistMotor = (int)map(werte[2], 0, 100, 20, 160);
        if (DEBUG) Serial.print("S: ");
        if (DEBUG) Serial.print(posSeiten);
        if (posSeiten < 10) if (DEBUG) Serial.print(" ");
        if (posSeiten < 100) if (DEBUG) Serial.print(" ");
        if (DEBUG) Serial.print("   H: ");
        if (DEBUG) Serial.print(posHoehen);
        if (posHoehen < 10) if (DEBUG) Serial.print(" ");
        if (posHoehen < 100) if (DEBUG) Serial.print(" ");
        if (DEBUG) Serial.print("   M: ");
        if (DEBUG) Serial.println(leistMotor);

        seitenRuder.write(posSeiten);
        hoehenRuder.write(posHoehen);
        motorRegler.write(leistMotor);

        for (int i = 0; i <= 2; i++) werte[i] = 0;
        arrayIndex = 0;
        packetcounter = len;
        lastsignal = millis();

        if ((zaehlSensor % 10 == 0)) //Modulo Funktion (Rest nach Division)
        {
          //Message muss Bezeichung haben sonst stuerzt ESP ab!!.
          OSCMessage msg("InfoASP");
          zeitSteuerNeu = millis();
          //Kommunikationszeit fuer 10 Zyklen an Smartphone senden
          msg.add((int32_t)((zeitSteuerNeu - zeitSteuerAlt) % 10000));
          //SSID des ESC an Smartphone senden
          msg.add(ssidap);
          Udp.beginPacket(Udp.remoteIP(), 12001);
          msg.send(Udp);
          Udp.endPacket();
          msg.empty();
          if (DEBUG) Serial.print("KommZeit: ");
          if (DEBUG) Serial.println((zeitSteuerNeu - zeitSteuerAlt) % 10000);
          zeitSteuerAlt = zeitSteuerNeu;
        }
        zaehlSensor++;
      }
    }
  }
  delay(10);
  if ((millis() - lastsignal) > 4000) {
    if (DEBUG) Serial.println("+++++++ Not Aus +++++++");
    seitenRuder.write(100);
    hoehenRuder.write(90);
    motorRegler.write(20);
  }
}

