//ArduSmartpilot App mit WiFi-Steuerung. Die Steuerung des Flugzeugs übernimmt hier ein ESP8288 µC statt des Arduino Pro Mini.
//*******
//Herzlichen Dank am G. Brandhorst für dieses Beispielprogramm!
//*******
//Vor dem Starten dieser App auf dem Smartphone muss eine WLAN-Verbindung mit dem ESP-201 (ESP8266) hergestellt werden.
//Ob die Kommunikation aufgebaut wurde, sieht man nach dem Start der App am schnellen Blinken der blauen LED auf dem ESP-201.
//Damit das Androidgerät beim Start der App nicht so ausgerichtet sein muss, wie durch den Quellcodebefehlt orientation()
//festgelegt, und damit die Ausrichtung des Bildschirms fest ist, muss im AndroidManifest.xml
//die Orientierung der App über android:screenOrientation="landscape" im <activity> Element definiert werden.
//Unter Android>Sketch Permissions muss (nur) "Internet" ausgewählt sein, damit WiFi Kommunikation möglich.
//Die Displayauflösung ist als kleinster gemeinsamer Nenner auf 800x480 festgelegt.
//Im Vergleich zu den Bluetooth ArduSmartPilot Apps wurde hier der Kippwinkelbereich für das Höhenruder auf 0...90° eingeschränkt.
//In dieser Version jetzt Rückkommunikation vom Smartphone.
//...
//7.12.15 S. Mack

import ketai.sensors.*;
import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

final static int XPOSBUT = 210, XSIZBUT = 100, YFIRBUT = 10, YDELBUT = 95, YSIZBUT = 80;
String datenString = ""; 

KetaiSensor sensor;

float beschleunigungX=0, beschleunigungY=0, beschleunigungZ=0;
int seitenRuder = 90, hoehenRuder = 90, motorLeistung = 0;
String feedbackArdu = "", ipArdu = "";

void setup()
{
  delay(3000);
  oscP5 = new OscP5(this, 12001); // Port 12001 für Empfang (ArduSmartPilot -> Android) 
  myRemoteLocation = new NetAddress("192.168.1.3", 12000); // Port 12000 zum Senden (Android -> Ardusmartpilot)
  size(800, 480);

  sensor = new KetaiSensor(this);
  sensor.start();
  frameRate(20);
}

void draw()
{
  background(255, 255, 0);

  int x=0, y=0;
  int kippWinkelY=0, kippWinkelX=0;
  strokeWeight(2);
  line(550, 20, 550, 460);
  line(320, 240, 780, 240);
  kippWinkelX = (int)(atan(beschleunigungY/beschleunigungZ)*180/PI);
  kippWinkelY = (int)(atan(beschleunigungX/beschleunigungZ)*180/PI);
  // Beruecksichtigt unterschiedliche Achsenausrichtungen bei den Tablets/Smartphones
  if (beschleunigungZ > 0)
  {
    kippWinkelY = 90;
    kippWinkelX = kippWinkelX * -1;
  }
  // Anders als in den BT-ArduSmartPilot Apps ist das Höhenruder horizontal, falls das Smartphone um 45° gekippt ist
  if (kippWinkelX > 45) kippWinkelX = 45;
  if (kippWinkelX < -45) kippWinkelX = -45;
  if (kippWinkelY > 90) kippWinkelY = 90;
  if (kippWinkelY < -0) kippWinkelY = 0;
  x = (int)map(kippWinkelX, -45, 45, 320, 780);
  y = (int)map(kippWinkelY, 0, 90, 20, 460);
  fill(255, 0, 0);
  ellipse(x, y, 30, 30);
  fill(0, 0, 0);

  if (mousePressed)
  {
    if ((mouseX>XPOSBUT)&&(mouseX<XPOSBUT+XSIZBUT)) 
    {
      if ((mouseY>YFIRBUT+(0*YDELBUT))&&(mouseY<YFIRBUT+(1*YSIZBUT)))  motorLeistung = 80;
      else if ((mouseY>YFIRBUT+(1*YDELBUT))&&(mouseY<YFIRBUT+(1*YDELBUT)+YSIZBUT))  motorLeistung = 65;
      else if ((mouseY>YFIRBUT+(2*YDELBUT))&&(mouseY<YFIRBUT+(2*YDELBUT)+YSIZBUT))  motorLeistung = 50;
      else if ((mouseY>YFIRBUT+(3*YDELBUT))&&(mouseY<YFIRBUT+(3*YDELBUT)+YSIZBUT))  motorLeistung = 35;
      else if ((mouseY>YFIRBUT+(4*YDELBUT))&&(mouseY<YFIRBUT+(4*YDELBUT)+YSIZBUT))  motorLeistung = 0;
    }
  }

  fill(255, 255, 255);
  rect(XPOSBUT, YFIRBUT+ (0*YDELBUT), XSIZBUT, YSIZBUT);
  rect(XPOSBUT, YFIRBUT+ (1*YDELBUT), XSIZBUT, YSIZBUT);
  rect(XPOSBUT, YFIRBUT+ (2*YDELBUT), XSIZBUT, YSIZBUT);
  rect(XPOSBUT, YFIRBUT+ (3*YDELBUT), XSIZBUT, YSIZBUT);
  rect(XPOSBUT, YFIRBUT+ (4*YDELBUT), XSIZBUT, YSIZBUT);

  fill (0, 255, 0);
  switch(motorLeistung)
  {
  case 80:
    rect(XPOSBUT, YFIRBUT+ (0*YDELBUT), XSIZBUT, YSIZBUT);
    break;
  case 65:
    rect(XPOSBUT, YFIRBUT+ (1*YDELBUT), XSIZBUT, YSIZBUT);
    break;
  case 50:
    rect(XPOSBUT, YFIRBUT+ (2*YDELBUT), XSIZBUT, YSIZBUT);
    break;
  case 35:
    rect(XPOSBUT, YFIRBUT+ (3*YDELBUT), XSIZBUT, YSIZBUT);
    break;
  case 0:
    rect(XPOSBUT, YFIRBUT+ (4*YDELBUT), XSIZBUT, YSIZBUT);
    break;
  }

  textSize(24);
  fill(0, 0, 0); 
  text("80 %", XPOSBUT+20, YFIRBUT+(0*YDELBUT)+50);
  text("65 %", XPOSBUT+20, YFIRBUT+(1*YDELBUT)+50);
  text("50 %", XPOSBUT+20, YFIRBUT+(2*YDELBUT)+50);
  text("35 %", XPOSBUT+20, YFIRBUT+(3*YDELBUT)+50);
  text("0 %", XPOSBUT+20, YFIRBUT+(4*YDELBUT)+50);

  // Anzeige Rückmeldung Arduino Zahl empfangener Werte
  text("Zykluszeit", 10, 100);
  text("Kommunik.:", 10, 100+30);
  text(feedbackArdu, 10, 100+60);

  // Anzeige Rückmeldung Arduino Sensorwert
  text("Verbunden", 10, 300);
  text("mit:", 10, 300+30);
  text(ipArdu, 10, 300+60);

  seitenRuder = (int)map(kippWinkelX, -45, 45, 0, 180);
  hoehenRuder = (int)map(kippWinkelY, 0, 90, 0, 180);

  datenString += seitenRuder + "," + hoehenRuder + "," + motorLeistung +"\n";

  OscMessage myMessage = new OscMessage(datenString);
  oscP5.send(myMessage, myRemoteLocation); 
  delay(50);
  datenString="";
}
// Damit diese Callbackfunktion anspringt muss der ESP auch OSC-Messages senden.
// Daher dort die esp8266-OSC Bibliothek verwenden
void oscEvent(OscMessage theOscMessage) 
{
  feedbackArdu=str(theOscMessage.get(0).intValue());
  ipArdu=theOscMessage.get(1).stringValue();
}

void onAccelerometerEvent(float x, float y, float z)
{
  beschleunigungX = -x;
  beschleunigungY = -y;
  beschleunigungZ = -z;
}

